#ifndef __GLOBAL_H__
#define __GLOBAL_H__

#include "AT89S52.h"

typedef  unsigned char   Byte;
typedef  unsigned int    Word;
typedef  unsigned long   DWord;
typedef  bit			 Bool;

/****************************************************************************/
/*  M A C R O   D E F I N I T I O N                                         */
/****************************************************************************/
#define ValBit(VAR,Place)         (VAR & (1<<Place))
#define SetBit(VAR,Place)         (VAR |= (1<<Place))
#define ResBit(VAR,Place)         (VAR &= ((1<<Place)^255))
#define XorBit(VAR,Place)         (VAR ^= (1<<Place))

#define	BIT0	0x01
#define	BIT1	0x02
#define	BIT2	0x04
#define	BIT3	0x08
#define	BIT4	0x10
#define	BIT5	0x20
#define	BIT6	0x40
#define	BIT7	0x80  

/********* LED Port Definition ************/
#define LEDPORT	P2
#define LED1 	P2_0
#define LED2 	P2_1
#define LED3 	P2_2
#define LED4 	P2_3
#define LED5 	P2_4
#define LED6 	P2_5
#define LED7 	P2_6
#define LED8 	P2_7

#define LED_ON		0
#define LED_OFF		1

/********* Button/Key Definition ************/
#define KEYPORT		P3
#define KEY1		P3_7
#define KEY2		P3_6
#define KEY3		P3_5
#define KEY4		P3_4
#define KEY5		P3_3
#define KEY6		P3_2

#define KEYUP		P3_2	//for INT0
#define KEYDOWN		P3_3	//for INT1

/********* BUZZER Definition ************/
#define BUZZER	P1_5

#define BUZZER_ON	0
#define BUZZER_OFF	1

/********* 7-Segment LED Definition (Common Anode) ************/
#define DATAPORT	P0		//data and digit control share the same port P0
#define DIGITPORT	P1		//data and digit control share the same port P0		

#define DIGIT_1		P1_3
#define DIGIT_2		P1_2
#define DIGIT_3		P1_1
#define DIGIT_4		P1_0

#define SEGLED_ON	0
#define SEGLED_OFF	1

/********* LCD1602 definition ******************/
#define DataPort P0
#define RS	P1_0
#define RW	P1_1
#define EN	P1_2

#define RS_CLR RS=0 
#define RS_SET RS=1

#define RW_CLR RW=0 
#define RW_SET RW=1 

#define EN_CLR EN=0
#define EN_SET EN=1

/********* LCD12864 definition ******************/
#define LCD_data 	P0
#define LCD_RS		P1_0
#define LCD_RW		P1_1
#define LCD_EN		P1_2
#define LCD_PSB 	P1_6 

#define RS_CLR RS=0 
#define RS_SET RS=1

#define RW_CLR RW=0 
#define RW_SET RW=1 

#define EN_CLR EN=0
#define EN_SET EN=1

/********* Infrared Receiver definition ******************/
#define IR		P3_3

/********* DS18B20 definition ******************/
#define DS18B20_DQ		P3_2

//DS18B20 command
#define SKIPROM 	0xCC
#define CONVERT		0x44
#define READTEMP 	0xBE

#endif

